/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

// pythonnet.h
#pragma once
#include "stdafx.h"

using namespace System;

namespace pythonnet
{
	public __delegate IPyObject * PyAPICallback (IPyObject *self, IPyObject *pParams);

	// The main python interface...
	public __gc class IPython
	{
	private:
		static IPython *_curr_python_obj;
	public:
		// ===========================================================
		// Constructor/Destructor Section
		// ===========================================================
		IPython();

		~IPython();

		// ===========================================================
		// Method Section
		// ===========================================================

		// Run a string of python code.
		void RunSimpleString(System::String *code);


		// Add a new module to the list of modules...
		IPyObject *AddModule(IPythonModule *module);

        System::Boolean DoesModuleExist(System::String *module_name);
		IPythonModule *GetModule(System::String *module_name);

		// Import a script
		IPyObject *Import(System::String *script_name);

		// Used to launch an API call back function...
		IPyObject * LaunchAPIFunction(System::String *module_name, System::String *function_name, IPyObject *self, IPyObject *args);

		// Add a new API function to the module...
		System::Boolean AddAPIFunction(System::String *module, System::String *func_name, System::Delegate *func);
		System::Boolean AddAPIFunction(IPythonModule *module, System::String *func_name, System::Delegate *func);

		IPyObject *CallPythonFunction(System::String *module_name, System::String *func_name, IPyTuple *args);

		static IPython *GetClass();
		static void SetClass(IPython *python_object);

		// ===========================================================
		// Private members section
		// ===========================================================
	private:		
		System::Collections::Hashtable *_modules;
	};	
}
