/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

// This is the main DLL file.

#include "stdafx.h"

#include "python.net.h"


namespace pythonnet
{
	IPython::IPython() {
		_curr_python_obj = this;
		Py_Initialize();
		_modules = new System::Collections::Hashtable();
	}

	IPython::~IPython() {
		Py_Finalize();
	}

	void IPython::RunSimpleString(System::String *code) {
		char* str = (char*)(void*)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(code);
		PyRun_SimpleString(str);
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str);

	}

	IPython *IPython::GetClass()
	{
		return _curr_python_obj;
	}

	void IPython::SetClass(IPython *python_object)
	{
		_curr_python_obj = python_object;
	}

	IPyObject *IPython::AddModule(IPythonModule *module)
	{
		PyObject *pyobj;
		char * str = (char*)(void *)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(module->ModuleName);
		pyobj = PyImport_AddModule(str);
		module->IPyModule = System::IntPtr(pyobj);
		if (pyobj) {
			IPyObject *ipyobj = new IPyObject((void *)pyobj);			
			_modules->Add(module->ModuleName, module);
			// Initialize the module...
			if (!Py_InitModule(str, NULL))
			{
				// If we get here, there was an error
				System::Runtime::InteropServices::Marshal::FreeHGlobal(str);
				return NULL;
			}
		
			System::Runtime::InteropServices::Marshal::FreeHGlobal(str);
			return ipyobj;
		}

		System::Runtime::InteropServices::Marshal::FreeHGlobal(str);
		return NULL;		
	}

	System::Boolean IPython::DoesModuleExist(System::String *module_name)
	{
		return _modules->ContainsKey(module_name);
	}

	IPyObject *IPython::Import(System::String *script_name)
	{
		char * str = (char*)(void *)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(script_name);
		PyObject *_script_name;
		_script_name = PyString_FromString(str);
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str);

		// This creates a module from the script loaded.
		PyObject *_script;
		_script = PyImport_Import(_script_name);
        
		return this->AddModule(new IPythonModule(new IPyObject(_script), script_name));
	}

	System::Boolean IPython::AddAPIFunction(System::String *module, System::String *func_name, System::Delegate *func)
	{
		if (! _modules->ContainsKey(module)) {
			IPythonModule *mod = new IPythonModule(module);
			this->AddModule(mod);
		}

		return this->AddAPIFunction(dynamic_cast<IPythonModule *>(_modules->get_Item(module)), func_name, func);
	}

	System::Boolean IPython::AddAPIFunction(IPythonModule *module, System::String *func_name, System::Delegate *func)
	{
		return module->AddAPIFunction(func_name, func);
	}

	IPythonModule *IPython::GetModule(System::String *module_name)
	{
		if (!this->DoesModuleExist(module_name)) {
			return NULL;
		}
		return dynamic_cast<IPythonModule *>(this->_modules->get_Item(module_name));
	}

	IPyObject * IPython::LaunchAPIFunction(System::String *module_name, System::String *function_name, IPyObject *self, IPyObject *args)
	{	
		//printf("Launching API function (%s.%s)\n", module_name, function_name);
		IPythonModule *mod;
		mod = this->GetModule(module_name);
		if (mod == NULL) {
			//printf("Unable to find module: %s\n", module_name);
			return new IPyObject();
		}

		return mod->LaunchAPIFunction(function_name, self, args);
		//return new IPyObject();
	}

	IPyObject *IPython::CallPythonFunction(System::String *module_name, System::String *func_name, IPyTuple *args)
	{
		IPythonModule *mod;
		PyObject *mod_ptr;
		PyObject *func_ptr;
		PyObject *args_ptr;
		PyObject *ret;

		// Get the module... If it is already in our cache, use that pointer
		mod = GetModule(module_name);
		if (mod == NULL)
		{
			// Module isn't loaded by us, lets check with the python engine
return NULL;
		} else {			
			mod_ptr = (PyObject *)mod->IPyModule.ToPointer();
		}

		// Get the dictionary for this module so that we can find the correct function
		PyObject *dict;
		dict = PyModule_GetDict(mod_ptr);
		if (dict == NULL)	// Failed to get the dictionary for this module...
			return NULL;
		
		char *str_func_name = (char*)(void *)	System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(func_name);
		// Extract a pointer to the proper function
		func_ptr = PyDict_GetItemString(dict, str_func_name);
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str_func_name);

		if (func_ptr == NULL) {			
			return NULL;
		}

		// Actually call the Python function
		if (args == NULL) {
			args_ptr = NULL;
		} else {
			args_ptr = (PyObject *)args->PythonObject->PythonObject.ToPointer();
		}
		//printf("Calling python function...\n");
		
		/*PyThreadState *tstate;
		tstate = PyThreadState_New(interp);
		PyEval_AcquireThread(tstate);*/

		ret = PyObject_CallObject(func_ptr, args_ptr);

		/*PyEval_ReleaseThread(tstate);
		PyThreadState_Delete(tstate);*/

		//printf("Function call complete...\n");
		return new IPyObject(ret);
	}
	
}
