/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#pragma once

#include "stdafx.h"

using namespace System;

namespace pythonnet
{
	// A python module
	public __gc class IPythonModule
	{
	public:
		// ===========================================================
		// Constructor/Destructor Section
		// ===========================================================
		IPythonModule();
		IPythonModule(System::String *module_name);
		IPythonModule(IPyObject *module, System::String *module_name);

		~IPythonModule();

		// ===========================================================
		// Property Section
		// ===========================================================
		__property void set_ModuleName(System::String *module_name);
		__property System::String *get_ModuleName();

		__property System::IntPtr get_IPyModule();
		__property void set_IPyModule(System::IntPtr mod);

		// ===========================================================
		// Method Section
		// ===========================================================

		// Add an API Function...
		System::Boolean AddAPIFunction(System::String *func_name, System::Delegate *func);

		System::Boolean DoesFunctionExist(System::String *function_name);

		// Launch a specified function
		IPyObject *LaunchAPIFunction(System::String *function_name, IPyObject *self, IPyObject *args);

		// ===========================================================
		// Call back method used when python function call our code.
		// ===========================================================
		// This function is called by the internal class...
		//__delegate bool EnumProc(IntPtr hwnd, IntPtr lParam);
		PyObject * API_MessagePump(PyObject *pSelf, PyObject *pParams);


		// This will return the current module class...
		static IPythonModule *GetClass();

		// ===========================================================
		// Private variables sections
		// ===========================================================
	private:
		System::String *_module_name;
		System::Collections::Hashtable *_func_table;
		System::IntPtr _py_module;

		static IPythonModule * _curr_module = NULL;
				
		__nogc class _CALLBACKCLASS // Inner class used to catch call backs from python
		{
		public:
			// This function is defined as stdcall and can  be used as a call back...
			static PyObject * API_Callback(PyObject *pSelf, PyObject *pParams)
			{								
				IPythonModule *mod = IPythonModule::GetClass();
				//pew->m_EnumProc->Invoke(hwnd, NULL);
				//printf("__stdcall Callback - Module: %s\n", mod->ModuleName);
				return mod->API_MessagePump(pSelf, pParams);
			}
		};

		_CALLBACKCLASS *_cbclass;
	};
}
