/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#include "stdafx.h"

#include "python.net.h"

#include "IPythonModule.h"

namespace pythonnet
{
	IPythonModule::IPythonModule()
	{
		_curr_module = this;
		_cbclass = new _CALLBACKCLASS();
		_func_table = new System::Collections::Hashtable();
	}

	IPythonModule::IPythonModule(System::String *module_name)
	{
		_curr_module = this;
		_cbclass = new _CALLBACKCLASS();
		set_ModuleName(module_name);
		_func_table = new System::Collections::Hashtable();
	}

	IPythonModule::IPythonModule(IPyObject *module, System::String *module_name)
	{
		_curr_module = this;
		_cbclass = new _CALLBACKCLASS();
		set_ModuleName(module_name);
		_func_table = new System::Collections::Hashtable();
		this->set_IPyModule(module->PythonObject);
	}

	IPythonModule::~IPythonModule()
	{
		delete _cbclass;
	}

	IPythonModule *IPythonModule::GetClass()
	{
		return _curr_module;
	}

	void IPythonModule::set_ModuleName(System::String *module_name)
	{
		_module_name = module_name;
	}

	System::String * IPythonModule::get_ModuleName()
	{
		if (_module_name == NULL) {
			return new System::String("");
		}
		else
		{
			return _module_name;
		}
	}

	System::IntPtr IPythonModule::get_IPyModule()
	{
		return _py_module;
	}

	void IPythonModule::set_IPyModule(System::IntPtr mod)
	{		
		_py_module = mod;
	}

	System::Boolean IPythonModule::AddAPIFunction(System::String *func_name, System::Delegate *func)
	{
		// Add this function to the function table...
		_func_table->Add(func_name, func);
		char * str_func_name = (char*)(void *)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(func_name);
		char * str_module_name = (char*)(void *)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(this->ModuleName);

		//printf("Adding Function: %s\n", str_func_name);
		
		/*static PyMethodDef HostAPIFuncs [] =
        {
			{ str_func_name, _CALLBACKCLASS::API_Callback, METH_VARARGS, NULL},			
            { NULL, NULL, NULL, NULL }
        };*/
		// Allocate funcs on the heap or it will cause the functions to be destroyed by python gc
		PyMethodDef *HostAPIFuncs = new PyMethodDef[2];
		HostAPIFuncs[0].ml_name = str_func_name;
		HostAPIFuncs[0].ml_meth = _CALLBACKCLASS::API_Callback;
		HostAPIFuncs[0].ml_flags = METH_VARARGS;
		HostAPIFuncs[0].ml_doc = NULL;
		HostAPIFuncs[1].ml_name = NULL;
		HostAPIFuncs[1].ml_meth = NULL;
		HostAPIFuncs[1].ml_flags = NULL;
		HostAPIFuncs[1].ml_doc = NULL;
        
		PyObject *_m;
		PyObject *_key;
		PyObject *_val;
		PyObject *self;
		self = PyDict_New();
		Py_INCREF(self);
		_key = PyString_FromString("__func_name__");
		_val = PyString_FromString(str_func_name);
		PyDict_SetItem(self, _key, _val);
		_key = PyString_FromString("__module_name__");
		_val = PyString_FromString(str_module_name);
		PyDict_SetItem(self, _key, _val);
		
		_m = Py_InitModule4(str_module_name, HostAPIFuncs, "", self, PYTHON_API_VERSION);
		
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str_func_name);
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str_module_name);
		if (_m == NULL ) {
			return false;
		}	
		return true;
	}

	System::Boolean IPythonModule::DoesFunctionExist(System::String *function_name)
	{
		return _func_table->ContainsKey(function_name);
	}

	IPyObject *IPythonModule::LaunchAPIFunction(System::String *function_name, IPyObject *self, IPyObject *args)
	{
		if (!this->DoesFunctionExist(function_name)) {
			printf("Function (%s) does not exist!\n", function_name);
			return new IPyObject;
		}
		
		// Need to launch the specified callback function.
		//printf("Launching API function (%s.%s)\n", this->ModuleName, function_name);
		//printf("launching call back...");

		pythonnet::PyAPICallback *cb;
		cb = dynamic_cast<pythonnet::PyAPICallback *>(_func_table->get_Item(function_name));

        return cb->Invoke(self, args);
		//return new IPyObject();
	}

	PyObject * IPythonModule::API_MessagePump(PyObject *pSelf, PyObject *pParams)
	{
		if (pSelf == NULL) {
			printf("pSelf is null, can't call function!\n");
			Py_INCREF(Py_None);
			return Py_None;
		}

		IPython *py;
		// Get the current instance of python
		py = IPython::GetClass();
		if (py == NULL)
		{
			printf("Unable to retrieve python class!\n");
			Py_INCREF(Py_None);		
			return Py_None;
		}
		
		// Extract the current module and function name from the calls
		PyObject *_val;		
		char * func_name;
		char * mod_name;
		
		_val = PyDict_GetItemString(pSelf, "__func_name__");
		
		func_name = PyString_AS_STRING(_val);

		_val = PyDict_GetItemString(pSelf, "__module_name__");

		mod_name = PyString_AS_STRING(_val);

		//printf("\tFunction Name: %s.%s", mod_name, func_name);
				
		System::String *m_name = new System::String(mod_name);
		System::String *f_name = new System::String(func_name);

		// Convert the PyObjects to IPyObjects
		IPyObject *self = new IPyObject(pSelf);
		IPyObject *params = new IPyObject(pParams);
		// Launch the specified function/module...		
		IPyObject *ret;
		ret = py->LaunchAPIFunction(m_name, f_name, self, params);

		return (PyObject *)ret->PythonObject.ToPointer();        
	}
	
}