/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#pragma once

#include "stdafx.h"

using namespace System;

namespace pythonnet
{
	// A python module
	public __gc class IPyTuple
	{
	public:
		// ===========================================================
		// Constructor/Destructor Section
		// ===========================================================
		IPyTuple();		
		IPyTuple(IPyObject *obj);
		IPyTuple(int num_items);
		
		~IPyTuple();

		// ===========================================================
		// Property Section
		// ===========================================================
		__property void set_PythonObject(IPyObject *obj);
		__property IPyObject *get_PythonObject();

		__property int get_TupleSize();

		// ===========================================================
		// Method Section
		// ===========================================================

		System::Boolean CreateNewTuple(int num_items);

		IPyObject * GetTupleItem(int pos);
		
		System::Int16 GetTupleItemAsInt16(int pos);
		System::Int32 GetTupleItemAsInt32(int pos);
		System::Int64 GetTupleItemAsInt64(int pos);
		System::Boolean GetTupleItemAsBoolean(int pos);
		System::Byte GetTupleItemAsByte(int pos);

		System::Double GetTupleItemAsDouble(int pos);
		System::Single GetTupleItemAsSingle(int pos);

		System::String *GetTupleItemAsString(int pos);


		System::Boolean SetTupleItem(int pos, IPyObject * obj);

		System::Boolean SetTupleItemAsInt16(int pos, System::Int16 val);
		System::Boolean SetTupleItemAsInt32(int pos, System::Int32 val);
		System::Boolean SetTupleItemAsInt64(int pos, System::Int64 val);
		System::Boolean SetTupleItemAsBoolean(int pos, System::Boolean val);
		System::Boolean SetTupleItemAsByte(int pos, System::Byte val);

		System::Boolean SetTupleItemAsDouble(int pos, System::Double val);
		System::Boolean SetTupleItemAsSingle(int pos, System::Single val);
		
		System::Boolean SetTupleItemAsString(int pos, System::String *val);

		// ===========================================================
		// Private variables sections
		// ===========================================================
	private:
		IPyObject *_ipy_object;

	};
}

