/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#include "stdafx.h"

#include "python.net.h"

#include "IPyObject.h"

#include "IPyTuple.h"


namespace pythonnet
{

	IPyTuple::IPyTuple()
	{
		CreateNewTuple(1);
	}

	IPyTuple::IPyTuple(IPyObject *obj)
	{
		set_PythonObject(obj);
	}

	IPyTuple::IPyTuple(int num_items)
	{
		CreateNewTuple(num_items);
	}

	System::Boolean IPyTuple::CreateNewTuple(int num_items)
	{
		if (num_items < 1)
			num_items = 1;
		PyObject *t;
		t = PyTuple_New(num_items);
		if (t == NULL)
			return false;
		if (_ipy_object != NULL)
			delete _ipy_object;
		_ipy_object = new IPyObject(t);
		return true;
	}

	IPyTuple::~IPyTuple()
	{
		if (_ipy_object != NULL)
			delete _ipy_object;
	}

	void IPyTuple::set_PythonObject(IPyObject *obj)
	{
		_ipy_object = obj;
	}

	IPyObject * IPyTuple::get_PythonObject()
	{
		return _ipy_object;
	}

	IPyObject *IPyTuple::GetTupleItem(int pos)
	{
		// Extract the specified pyobject from the tuple
		if (pos > TupleSize -1 || pos < 0)
		{
			// This tuple doesn't have that many items in it.
			return new IPyObject();
		}

		PyObject *tuple;
		tuple = (PyObject *)_ipy_object->PythonObject.ToPointer();
		IPyObject *item;
		item = new IPyObject(PyTuple_GetItem(tuple, pos));
		return item;
	}

	System::Boolean IPyTuple::SetTupleItem(int pos, IPyObject * obj)
	{
		if (pos > TupleSize - 1 || pos < 0) {
			return false;
		}

		PyObject *tuple;
		tuple = (PyObject *)_ipy_object->PythonObject.ToPointer();
		PyObject *item;
		item = (PyObject *)obj->PythonObject.ToPointer();
		int ret;
		ret = PyTuple_SetItem(tuple, pos, item);
		if (ret != 0)
			return false;
		return true;
	}

	int IPyTuple::get_TupleSize()
	{
		PyObject *obj;
		obj = (PyObject *) _ipy_object->PythonObject.ToPointer();
		return PyTuple_Size(obj);
	}

	System::Int16 IPyTuple::GetTupleItemAsInt16(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToInt16();
	}

	System::Int32 IPyTuple::GetTupleItemAsInt32(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToInt32();
	}

	System::Int64 IPyTuple::GetTupleItemAsInt64(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToInt64();
	}

	System::Boolean IPyTuple::GetTupleItemAsBoolean(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToBoolean();
	}

	System::Byte IPyTuple::GetTupleItemAsByte(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToByte();
	}

	System::Double IPyTuple::GetTupleItemAsDouble(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToDouble();
	}

	System::Single IPyTuple::GetTupleItemAsSingle(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToSingle();
	}

	System::String *IPyTuple::GetTupleItemAsString(int pos)
	{
		IPyObject *obj;
		obj = GetTupleItem(pos);
		return obj->ConvertToString();
	}


	System::Boolean IPyTuple::SetTupleItemAsInt16(int pos, System::Int16 val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToInt16(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsInt32(int pos, System::Int32 val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToInt32(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsInt64(int pos, System::Int64 val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToInt64(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsBoolean(int pos, System::Boolean val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToBoolean(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsByte(int pos, System::Byte val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToByte(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsDouble(int pos, System::Double val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToDouble(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsSingle(int pos, System::Single val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToSingle(val);
		return SetTupleItem(pos, obj);
	}

	System::Boolean IPyTuple::SetTupleItemAsString(int pos, System::String *val)
	{
		IPyObject *obj = new IPyObject();
		obj->SetToString(val);
		return SetTupleItem(pos, obj);
	}

}
