/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#pragma once

#include "stdafx.h"

using namespace System;

namespace pythonnet
{
	// A python module
	public __gc class IPyObject
	{
	public:
		// ===========================================================
		// Constructor/Destructor Section
		// ===========================================================
		IPyObject();
		IPyObject(System::IntPtr obj);
		IPyObject(void * obj);
		
		~IPyObject();

		// ===========================================================
		// Property Section
		// ===========================================================		
		__property void set_PythonObject(System::IntPtr p);
		__property System::IntPtr get_PythonObject();

		// ===========================================================
		// Method Section
		// ===========================================================
		System::Int16 ConvertToInt16();
		System::Int32 ConvertToInt32();
		System::Int64 ConvertToInt64();
		System::Boolean ConvertToBoolean();
		System::Byte ConvertToByte();

		System::Double ConvertToDouble();
		System::Single ConvertToSingle();

		System::String *ConvertToString();

		System::Boolean SetToInt16(System::Int16 val);
		System::Boolean SetToInt32(System::Int32 val);
		System::Boolean SetToInt64(System::Int64 val);
		System::Boolean SetToBoolean(System::Boolean val);
		System::Boolean SetToByte(System::Byte val);

		System::Boolean SetToDouble(System::Double val);
		System::Boolean SetToSingle(System::Single val);

		System::Boolean SetToString(System::String *val);

		// ===========================================================
		// Private variables sections
		// ===========================================================
	private:
		System::IntPtr _pyObject;

		void ClearCurrentObject();

	};
}
