/*
PythonDotNet - Embed Python engine into Dot Net Application  Copyright (C) 2005 Computer Magic And Software Design 

Go to http://computermagic.mine.nu or email computermagic@hotmail.com for original source distribution.

This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

*/

#include "stdafx.h"

#include "python.net.h"

#include "IPyObject.h"


namespace pythonnet
{
	IPyObject::IPyObject()
	{
		Py_INCREF(Py_None);
		_pyObject = Py_None;
	}

	IPyObject::IPyObject(System::IntPtr obj)
	{
		set_PythonObject(obj);
	}

	IPyObject::IPyObject(void * obj)
	{
		//System::IntPtr __nogc *iptr;
		//iptr =  __nogc new System::IntPtr(obj);
		set_PythonObject(obj);
	}

	IPyObject::~IPyObject()
	{	
	}

	void IPyObject::ClearCurrentObject()
	{
		if (_pyObject != System::IntPtr::Zero) {
			PyObject *obj;
			obj = (PyObject *) _pyObject.ToPointer();
			Py_DECREF(obj);
			_pyObject = System::IntPtr::Zero;
		}
	}

	void IPyObject::set_PythonObject(System::IntPtr obj)
	{
		//_pyObject = (PyObject *) obj->ToPointer();
		PyObject * o;
		o = (PyObject *) obj.ToPointer();
		if (o == NULL) {
			o = Py_None;
		}
		Py_INCREF(o);
		_pyObject = obj;
	}

	System::IntPtr IPyObject::get_PythonObject()
	{
		//System::IntPtr obj;
		//obj = __nogc new System::IntPtr((void *) _pyObject);
		//return System::Runtime::InteropServices::Marshal::AllocHGlobal(obj);
		return _pyObject;		
	}

	System::Int16 IPyObject::ConvertToInt16()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj)) {
			// The item is an int object
			PyObject *num;
			Int16 n;
			num = PyNumber_Int(obj);
			n = Convert::ToInt16(PyInt_AsLong(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}


	System::Int32 IPyObject::ConvertToInt32()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an int object
			PyObject *num;
			Int32 n;
			num = PyNumber_Long(obj);
			n = Convert::ToInt32(PyLong_AsLong(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}

	System::Int64 IPyObject::ConvertToInt64()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an int object
			PyObject *num;
			Int64 n;
			num = PyNumber_Long(obj);
			n = Convert::ToInt64(PyLong_AsLongLong(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}

	System::Boolean IPyObject::ConvertToBoolean()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an int object
			PyObject *num;
			System::Boolean n;
			num = PyNumber_Long(obj);
			n = Convert::ToBoolean(PyInt_AsLong(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}

	System::Byte IPyObject::ConvertToByte()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an int object
			PyObject *num;
			System::Byte n;
			num = PyNumber_Int(obj);
			n = Convert::ToByte(PyInt_AsLong(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}
    
	System::Double IPyObject::ConvertToDouble()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an num object
			PyObject *num;
			Double n;
			num = PyNumber_Float(obj);
			n = PyFloat_AsDouble(num);
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}

	System::Single IPyObject::ConvertToSingle()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyNumber_Check(obj))
		{
			// The item is an num object
			PyObject *num;
			System::Single n;
			num = PyNumber_Float(obj);
			n = Convert::ToSingle(PyFloat_AsDouble(num));
			Py_DECREF(num);
			return n;
		}
		return NULL;
	}

	System::String *IPyObject::ConvertToString()
	{
		PyObject *obj;
		obj = (PyObject *)_pyObject.ToPointer();
		if (PyString_Check(obj)) {
			char * str;
			str = PyString_AsString(obj);
			String *s;
			s = new String(str);
			return s;
		}
		return NULL;
	}


	System::Boolean IPyObject::SetToInt16(System::Int16 val)
	{
		PyObject *obj;
		obj = PyLong_FromLong(val);
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToInt32(System::Int32 val)
	{
		PyObject *obj;
		obj = PyLong_FromLong(val);
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToInt64(System::Int64 val)
	{
		PyObject *obj;
		obj = PyLong_FromLongLong(val);
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToBoolean(System::Boolean val)
	{
		PyObject *obj;
		obj = PyInt_FromLong(Convert::ToInt32(val));
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToByte(System::Byte val)
	{
		PyObject *obj;
		obj = PyInt_FromLong(Convert::ToInt32(val));
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToDouble(System::Double val)
	{
		PyObject *obj;
		obj = PyFloat_FromDouble(val);
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToSingle(System::Single val)
	{
		PyObject *obj;
		obj = PyFloat_FromDouble(Convert::ToDouble(val));
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}

	System::Boolean IPyObject::SetToString(System::String *val)
	{
		char * str_val = (char*)(void *)
			System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(val);
		PyObject *obj;
		obj = PyString_FromString(str_val);
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str_val);
		if (obj == NULL) {
			return false;
		}
		_pyObject = System::IntPtr(obj);
		return true;
	}
}